%------------------------------------------------------------------------------
% File     : CSR153^1 : TPTP v9.2.0. Released v4.1.0.
% Domain   : Commonsense Reasoning
% Problem  : Is there a common relation?
% Version  : Especial > Reduced > Especial.
% English  : Mary, Sue, Bill and Bob are mutually distinct. Mary is neither a
%            sister of Sue nor of Bill. Bob is not a brother of Mary. Sue is a
%            sister of Bill and of Bob. Bob is a brother of Bill. Is there a 
%            relation that holds both between Bob and Bill and between Sue and 
%            Bob?

% Refs     : [PS07]  Pease & Sutcliffe (2007), First Order Reasoning on a L
%          : [BP10]  Benzmueller & Pease (2010), Progress in Automating Hig
%          : [Ben10] Benzmueller (2010), Email to Geoff Sutcliffe
% Source   : [Ben10]
% Names    : paar_9.tq_SUMO_local [Ben10]

% Status   : Theorem
% Rating   : 0.22 v9.1.0, 0.25 v9.0.0, 0.20 v8.2.0, 0.46 v8.1.0, 0.45 v7.5.0, 0.29 v7.4.0, 0.11 v7.2.0, 0.00 v7.1.0, 0.25 v7.0.0, 0.14 v6.4.0, 0.17 v6.3.0, 0.20 v6.2.0, 0.14 v6.1.0, 0.57 v6.0.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.2.0, 0.20 v5.1.0, 0.40 v5.0.0, 0.60 v4.1.0
% Syntax   : Number of formulae    :   13 (   1 unt;   7 typ;   0 def)
%            Number of atoms       :   22 (   6 equ;  10 cnn)
%            Maximal formula atoms :    6 (   3 avg)
%            Number of connectives :   47 (  10   ~;   0   |;   9   &;  28   @)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   5 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :    6 (   6   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    8 (   6 usr;   5 con; 0-2 aty)
%            Number of variables   :    3 (   0   ^;   2   !;   1   ?;   3   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This is a simple test problem for reasoning in/about SUMO.
%            Initally the problem has been hand generated in KIF syntax in
%            SigmaKEE and then automatically translated by Benzmueller's
%            KIF2TH0 translator into THF syntax.
%          : The translation has been applied in two modes: local and SInE.
%            The local mode only translates the local assumptions and the
%            query. The SInE mode additionally translates the SInE-extract
%            of the loaded knowledge base (usually SUMO).
%          : The examples are selected to illustrate the benefits of
%            higher-order reasoning in ontology reasoning.
%------------------------------------------------------------------------------
%----The extracted Signature
thf(numbers,type,
    num: $tType ).

thf(brother_THFTYPE_IiioI,type,
    brother_THFTYPE_IiioI: $i > $i > $o ).

thf(lBill_THFTYPE_i,type,
    lBill_THFTYPE_i: $i ).

thf(lBob_THFTYPE_i,type,
    lBob_THFTYPE_i: $i ).

thf(lMary_THFTYPE_i,type,
    lMary_THFTYPE_i: $i ).

thf(lSue_THFTYPE_i,type,
    lSue_THFTYPE_i: $i ).

thf(sister_THFTYPE_IiioI,type,
    sister_THFTYPE_IiioI: $i > $i > $o ).

%----The translated axioms
thf(ax,axiom,
    ( ( sister_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i )
    & ( sister_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBob_THFTYPE_i )
    & ( brother_THFTYPE_IiioI @ lBob_THFTYPE_i @ lBill_THFTYPE_i ) ) ).

thf(ax_001,axiom,
    ( ( (~) @ ( lMary_THFTYPE_i = lSue_THFTYPE_i ) )
    & ( (~) @ ( lMary_THFTYPE_i = lBill_THFTYPE_i ) )
    & ( (~) @ ( lBob_THFTYPE_i = lMary_THFTYPE_i ) ) ) ).

thf(ax_002,axiom,
    ( ( (~) @ ( lSue_THFTYPE_i = lBill_THFTYPE_i ) )
    & ( (~) @ ( lSue_THFTYPE_i = lBob_THFTYPE_i ) ) ) ).

thf(ax_003,axiom,
    ( ( (~) @ ( sister_THFTYPE_IiioI @ lMary_THFTYPE_i @ lSue_THFTYPE_i ) )
    & ( (~) @ ( sister_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBill_THFTYPE_i ) )
    & ( (~) @ ( brother_THFTYPE_IiioI @ lBob_THFTYPE_i @ lMary_THFTYPE_i ) ) ) ).

thf(ax_004,axiom,
    (~) @ ( lBob_THFTYPE_i = lBill_THFTYPE_i ) ).

%----The translated conjectures
thf(con,conjecture,
    ? [R: $i > $i > $o] :
      ( ( R @ lBob_THFTYPE_i @ lBill_THFTYPE_i )
      & ( R @ lSue_THFTYPE_i @ lBob_THFTYPE_i )
      & ( (~)
        @ ! [X: $i,Y: $i] : ( R @ X @ Y ) ) ) ).

%------------------------------------------------------------------------------
